<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Setup Token Request where the `source` defines the type of instrument to be stored.
 */
class SetupTokenRequest implements \JsonSerializable
{
    /**
     * @var CustomerRequest|null
     */
    private $customer;

    /**
     * @var SetupTokenRequestPaymentSource
     */
    private $paymentSource;

    /**
     * @param SetupTokenRequestPaymentSource $paymentSource
     */
    public function __construct(SetupTokenRequestPaymentSource $paymentSource)
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Customer.
     * Customer in merchant's or partner's system of records.
     */
    public function getCustomer(): ?CustomerRequest
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * Customer in merchant's or partner's system of records.
     *
     * @maps customer
     */
    public function setCustomer(?CustomerRequest $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Payment Source.
     * The payment method to vault with the instrument details.
     */
    public function getPaymentSource(): SetupTokenRequestPaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment method to vault with the instrument details.
     *
     * @required
     * @maps payment_source
     */
    public function setPaymentSource(SetupTokenRequestPaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->customer)) {
            $json['customer']   = $this->customer;
        }
        $json['payment_source'] = $this->paymentSource;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
