<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * The payment method to vault with the instrument details.
 */
class PaymentTokenRequestPaymentSource implements \JsonSerializable
{
    /**
     * @var PaymentTokenRequestCard|null
     */
    private $card;

    /**
     * @var VaultTokenRequest|null
     */
    private $token;

    /**
     * Returns Card.
     * A Resource representing a request to vault a Card.
     */
    public function getCard(): ?PaymentTokenRequestCard
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * A Resource representing a request to vault a Card.
     *
     * @maps card
     */
    public function setCard(?PaymentTokenRequestCard $card): void
    {
        $this->card = $card;
    }

    /**
     * Returns Token.
     * The Tokenized Payment Source representing a Request to Vault a Token.
     */
    public function getToken(): ?VaultTokenRequest
    {
        return $this->token;
    }

    /**
     * Sets Token.
     * The Tokenized Payment Source representing a Request to Vault a Token.
     *
     * @maps token
     */
    public function setToken(?VaultTokenRequest $token): void
    {
        $this->token = $token;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card']  = $this->card;
        }
        if (isset($this->token)) {
            $json['token'] = $this->token;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
