<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;
use PaypalServerSdkLib\Models\VaultExperienceContext;
use PaypalServerSdkLib\Models\VaultPaypalWalletRequest;

/**
 * Builder for model VaultPaypalWalletRequest
 *
 * @see VaultPaypalWalletRequest
 */
class VaultPaypalWalletRequestBuilder
{
    /**
     * @var VaultPaypalWalletRequest
     */
    private $instance;

    private function __construct(VaultPaypalWalletRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new vault paypal wallet request Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultPaypalWalletRequest());
    }

    /**
     * Sets description field.
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets shipping field.
     */
    public function shipping(?VaultedDigitalWalletShippingDetails $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Sets usage type field.
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?VaultExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new vault paypal wallet request object.
     */
    public function build(): VaultPaypalWalletRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
