<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayAttributes;
use PaypalServerSdkLib\Models\ApplePayDecryptedTokenData;
use PaypalServerSdkLib\Models\ApplePayRequest;
use PaypalServerSdkLib\Models\CardStoredCredential;
use PaypalServerSdkLib\Models\PhoneNumber;

/**
 * Builder for model ApplePayRequest
 *
 * @see ApplePayRequest
 */
class ApplePayRequestBuilder
{
    /**
     * @var ApplePayRequest
     */
    private $instance;

    private function __construct(ApplePayRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new apple pay request Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayRequest());
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets email address field.
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets phone number field.
     */
    public function phoneNumber(?PhoneNumber $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Sets decrypted token field.
     */
    public function decryptedToken(?ApplePayDecryptedTokenData $value): self
    {
        $this->instance->setDecryptedToken($value);
        return $this;
    }

    /**
     * Sets stored credential field.
     */
    public function storedCredential(?CardStoredCredential $value): self
    {
        $this->instance->setStoredCredential($value);
        return $this;
    }

    /**
     * Sets vault id field.
     */
    public function vaultId(?string $value): self
    {
        $this->instance->setVaultId($value);
        return $this;
    }

    /**
     * Sets attributes field.
     */
    public function attributes(?ApplePayAttributes $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Initializes a new apple pay request object.
     */
    public function build(): ApplePayRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
