<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayAttributesResponse;
use PaypalServerSdkLib\Models\ApplePayCardResponse;
use PaypalServerSdkLib\Models\ApplePayPaymentObject;
use PaypalServerSdkLib\Models\PhoneNumber;

/**
 * Builder for model ApplePayPaymentObject
 *
 * @see ApplePayPaymentObject
 */
class ApplePayPaymentObjectBuilder
{
    /**
     * @var ApplePayPaymentObject
     */
    private $instance;

    private function __construct(ApplePayPaymentObject $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new apple pay payment object Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayPaymentObject());
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets token field.
     */
    public function token(?string $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets email address field.
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets phone number field.
     */
    public function phoneNumber(?PhoneNumber $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Sets card field.
     */
    public function card(?ApplePayCardResponse $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets attributes field.
     */
    public function attributes(?ApplePayAttributesResponse $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Initializes a new apple pay payment object object.
     */
    public function build(): ApplePayPaymentObject
    {
        return CoreHelper::clone($this->instance);
    }
}
