<?php //15780b1f92664cd70b596cf74ddb0716
/** @noinspection all */

namespace Codeglen\Usupport\Models {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_FaqCategory_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_FaqCategory_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_Faq_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_Faq_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportAgent_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportAgent_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportArticle_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportArticle_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportCategory_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportCategory_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportSettings_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportSettings_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportTicket_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_SupportTicket_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketAttachment_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketAttachment_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketReply_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketReply_QB;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketTags_C;
    use LaravelIdea\Helper\Codeglen\Usupport\Models\_IH_TicketTags_QB;
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $faq_category_id
     * @property string $question
     * @property string $answer
     * @property int $sort_order
     * @property bool $is_published
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Faq_QB onWriteConnection()
     * @method _IH_Faq_QB newQuery()
     * @method static _IH_Faq_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Faq_QB query()
     * @method static _IH_Faq_QB with(array|string $relations)
     * @method _IH_Faq_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Faq_C|Faq[] all($columns = ['*'])
     * @ownLinks faq_category_id,\Codeglen\Usupport\Models\FaqCategory,id
     * @mixin _IH_Faq_QB
     */
    class Faq extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $slug
     * @property string|null $icon
     * @property string|null $description
     * @property int $sort_order
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Faq_C|Faq[] $faqs
     * @property-read int $faqs_count
     * @method HasMany|_IH_Faq_QB faqs()
     * @method static _IH_FaqCategory_QB onWriteConnection()
     * @method _IH_FaqCategory_QB newQuery()
     * @method static _IH_FaqCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_FaqCategory_QB query()
     * @method static _IH_FaqCategory_QB with(array|string $relations)
     * @method _IH_FaqCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FaqCategory_C|FaqCategory[] all($columns = ['*'])
     * @foreignLinks id,\Codeglen\Usupport\Models\Faq,faq_category_id
     * @mixin _IH_FaqCategory_QB
     */
    class FaqCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property int $user_id
     * @property string|null $designation
     * @property string|null $bio
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read int $closed_tickets_count attribute
     * @property-read int $open_tickets_count attribute
     * @property _IH_SupportTicket_C|SupportTicket[] $tickets
     * @property-read int $tickets_count
     * @method HasMany|_IH_SupportTicket_QB tickets()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SupportAgent_QB onWriteConnection()
     * @method _IH_SupportAgent_QB newQuery()
     * @method static _IH_SupportAgent_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SupportAgent_QB query()
     * @method static _IH_SupportAgent_QB with(array|string $relations)
     * @method _IH_SupportAgent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportAgent_C|SupportAgent[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\Codeglen\Usupport\Models\SupportCategory,agent_id
     * @mixin _IH_SupportAgent_QB
     */
    class SupportAgent extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $title
     * @property string $slug
     * @property string $content
     * @property int|null $category_id
     * @property int|null $created_by
     * @property bool $is_published
     * @property bool $is_featured
     * @property int $views
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SupportCategory|null $category
     * @method BelongsTo|_IH_SupportCategory_QB category()
     * @property User|null $createdBy
     * @method BelongsTo|_IH_User_QB createdBy()
     * @method static _IH_SupportArticle_QB onWriteConnection()
     * @method _IH_SupportArticle_QB newQuery()
     * @method static _IH_SupportArticle_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SupportArticle_QB query()
     * @method static _IH_SupportArticle_QB with(array|string $relations)
     * @method _IH_SupportArticle_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportArticle_C|SupportArticle[] all($columns = ['*'])
     * @ownLinks category_id,\Codeglen\Usupport\Models\SupportCategory,id|created_by,\App\Models\User,id
     * @mixin _IH_SupportArticle_QB
     */
    class SupportArticle extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $name
     * @property string $slug
     * @property string $icon
     * @property string|null $description
     * @property bool $is_active
     * @property int|null $agent_id
     * @property int|null $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SupportAgent|null $agent
     * @method BelongsTo|_IH_SupportAgent_QB agent()
     * @property _IH_SupportArticle_C|SupportArticle[] $articles
     * @property-read int $articles_count
     * @method HasMany|_IH_SupportArticle_QB articles()
     * @property User|null $createdBy
     * @method BelongsTo|_IH_User_QB createdBy()
     * @property _IH_SupportTicket_C|SupportTicket[] $tickets
     * @property-read int $tickets_count
     * @method HasMany|_IH_SupportTicket_QB tickets()
     * @method static _IH_SupportCategory_QB onWriteConnection()
     * @method _IH_SupportCategory_QB newQuery()
     * @method static _IH_SupportCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SupportCategory_QB query()
     * @method static _IH_SupportCategory_QB with(array|string $relations)
     * @method _IH_SupportCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportCategory_C|SupportCategory[] all($columns = ['*'])
     * @ownLinks agent_id,\Codeglen\Usupport\Models\SupportAgent,id|created_by,\App\Models\User,id
     * @foreignLinks id,\Codeglen\Usupport\Models\SupportArticle,category_id|id,\Codeglen\Usupport\Models\SupportTicket,category_id
     * @mixin _IH_SupportCategory_QB
     */
    class SupportCategory extends Model {}
    
    /**
     * @property int $id
     * @property string|null $desk_name
     * @property string|null $desk_email
     * @property bool $auto_reassign_ticket
     * @property bool $filter_articles_by_category
     * @property bool $disable_public_tickets
     * @property bool $public_ticket_default
     * @property bool $order_tickets_asc
     * @property bool $group_tickets_by_updated_date
     * @property bool $enable_autoresponder
     * @property string|null $autoresponder_message
     * @property bool $enable_email_tickets
     * @property bool $important_notice
     * @property string|null $important_notice_message
     * @property bool $private_ticketing
     * @property bool $limit_support_agents
     * @property bool $hide_customers_from_agents
     * @property bool $hide_purchase_data_from_agents
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportSettings_QB onWriteConnection()
     * @method _IH_SupportSettings_QB newQuery()
     * @method static _IH_SupportSettings_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SupportSettings_QB query()
     * @method static _IH_SupportSettings_QB with(array|string $relations)
     * @method _IH_SupportSettings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportSettings_C|SupportSettings[] all($columns = ['*'])
     * @mixin _IH_SupportSettings_QB
     */
    class SupportSettings extends Model {}
    
    /**
     * @property int $id
     * @property string $uid
     * @property string $subject
     * @property string $status
     * @property string $priority
     * @property int $customer_id
     * @property int|null $agent_id
     * @property int|null $created_by
     * @property int|null $category_id
     * @property int|null $last_replied_by
     * @property string|null $note
     * @property string|null $customer_note
     * @property string|null $related_url
     * @property bool $is_public
     * @property bool $mark_starred
     * @property Carbon|null $last_replied_at
     * @property Carbon|null $closed_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SupportAgent|null $agent
     * @method BelongsTo|_IH_SupportAgent_QB agent()
     * @property _IH_TicketAttachment_C|TicketAttachment[] $attachments
     * @property-read int $attachments_count
     * @method HasMany|_IH_TicketAttachment_QB attachments()
     * @property SupportCategory|null $category
     * @method BelongsTo|_IH_SupportCategory_QB category()
     * @property User $customer
     * @method BelongsTo|_IH_User_QB customer()
     * @property User|null $lastReplier
     * @method BelongsTo|_IH_User_QB lastReplier()
     * @property _IH_TicketReply_C|TicketReply[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_TicketReply_QB replies()
     * @property _IH_TicketTags_C|TicketTags[] $tags
     * @property-read int $tags_count
     * @method BelongsToMany|_IH_TicketTags_QB tags()
     * @method static _IH_SupportTicket_QB onWriteConnection()
     * @method _IH_SupportTicket_QB newQuery()
     * @method static _IH_SupportTicket_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SupportTicket_QB query()
     * @method static _IH_SupportTicket_QB with(array|string $relations)
     * @method _IH_SupportTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicket_C|SupportTicket[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\User,id|agent_id,\App\Models\User,id|created_by,\App\Models\User,id|last_replied_by,\App\Models\User,id|category_id,\Codeglen\Usupport\Models\SupportCategory,id
     * @foreignLinks id,\Codeglen\Usupport\Models\TicketReply,ticket_id|id,\Codeglen\Usupport\Models\TicketAttachment,ticket_id
     * @mixin _IH_SupportTicket_QB
     */
    class SupportTicket extends Model {}
    
    /**
     * @property int $id
     * @property int $ticket_id
     * @property int $reply_id
     * @property string $filename
     * @property string $filepath
     * @property string|null $mime_type
     * @property int|null $file_size
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property TicketReply $reply
     * @method BelongsTo|_IH_TicketReply_QB reply()
     * @property SupportTicket $ticket
     * @method BelongsTo|_IH_SupportTicket_QB ticket()
     * @method static _IH_TicketAttachment_QB onWriteConnection()
     * @method _IH_TicketAttachment_QB newQuery()
     * @method static _IH_TicketAttachment_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_TicketAttachment_QB query()
     * @method static _IH_TicketAttachment_QB with(array|string $relations)
     * @method _IH_TicketAttachment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketAttachment_C|TicketAttachment[] all($columns = ['*'])
     * @ownLinks ticket_id,\Codeglen\Usupport\Models\SupportTicket,id|reply_id,\Codeglen\Usupport\Models\TicketReply,id
     * @mixin _IH_TicketAttachment_QB
     */
    class TicketAttachment extends Model {}
    
    /**
     * @property int $id
     * @property int $ticket_id
     * @property int $user_id
     * @property bool $is_customer_reply
     * @property bool $is_private
     * @property string $message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_TicketAttachment_C|TicketAttachment[] $attachments
     * @property-read int $attachments_count
     * @method HasMany|_IH_TicketAttachment_QB attachments()
     * @property SupportTicket $ticket
     * @method BelongsTo|_IH_SupportTicket_QB ticket()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_TicketReply_QB onWriteConnection()
     * @method _IH_TicketReply_QB newQuery()
     * @method static _IH_TicketReply_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_TicketReply_QB query()
     * @method static _IH_TicketReply_QB with(array|string $relations)
     * @method _IH_TicketReply_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketReply_C|TicketReply[] all($columns = ['*'])
     * @ownLinks ticket_id,\Codeglen\Usupport\Models\SupportTicket,id|user_id,\App\Models\User,id
     * @foreignLinks id,\Codeglen\Usupport\Models\TicketAttachment,reply_id
     * @mixin _IH_TicketReply_QB
     */
    class TicketReply extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $color
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_SupportTicket_C|SupportTicket[] $tickets
     * @property-read int $tickets_count
     * @method BelongsToMany|_IH_SupportTicket_QB tickets()
     * @method static _IH_TicketTags_QB onWriteConnection()
     * @method _IH_TicketTags_QB newQuery()
     * @method static _IH_TicketTags_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_TicketTags_QB query()
     * @method static _IH_TicketTags_QB with(array|string $relations)
     * @method _IH_TicketTags_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketTags_C|TicketTags[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_TicketTags_QB
     */
    class TicketTags extends Model {}
}